<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\User;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\User\UserModel;
use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Models\User\UserValidator;
use Erlage\Photogram\Data\Models\User\UserTransformer;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

final class UserTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'user';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    // ids

    const ID = 'id';

    // creds

    const EMAIL = 'email';

    const USERNAME = 'username';

    const PASSWORD = 'password';

    // display

    const DISPLAY_NAME = 'display_name';

    const DISPLAY_BIO = 'display_bio';

    const DISPLAY_IMAGE = 'display_image';

    const DISPLAY_WEB = 'display_web';

    // meta

    const META_ACCESS = 'meta_access';

    const META_IS_PRIVATE = 'meta_is_private';

    const META_IS_EMAIL_VERIFIED = 'meta_is_email_verified';

    const META_LAST_ACTIVE = 'meta_last_active';

    const META_PUSH_SETTINGS = 'meta_push_settings';

    // cache

    const CACHE_POSTS_COUNT = 'cache_posts_count';

    const CACHE_FOLLOWERS_COUNT = 'cache_followers_count';

    const CACHE_FOLLOWINGS_COUNT = 'cache_followings_count';

    // server only attributes

    const CACHE_BLOCKED_USER_IDS = 'cache_blocked_user_ids';

    // stamp

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    // extra fields(not present in database)
    const EXTRA_NEW_PASSWORD = 'extra_new_password';

    const EXTRA_RETYPE_NEW_PASSWORD = 'extra_retype_new_password';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID                      => 'id',

        self::EMAIL                   => 'email',
        self::USERNAME                => 'username',
        self::PASSWORD                => 'password',

        self::DISPLAY_NAME            => 'displayName',
        self::DISPLAY_IMAGE           => 'displayImage',
        self::DISPLAY_BIO             => 'displayBio',
        self::DISPLAY_WEB             => 'displayWeb',

        self::META_ACCESS             => 'metaAccess',
        self::META_IS_PRIVATE         => 'metaIsPrivate',
        self::META_IS_EMAIL_VERIFIED  => 'metaIsEmailVerified',
        self::META_LAST_ACTIVE        => 'metaLastActive',
        self::META_PUSH_SETTINGS      => 'metaPushSettings',

        self::CACHE_POSTS_COUNT       => 'cachePostsCount',
        self::CACHE_FOLLOWERS_COUNT   => 'cacheFollowersCount',
        self::CACHE_FOLLOWINGS_COUNT  => 'cacheFollowingsCount',
        self::CACHE_BLOCKED_USER_IDS  => 'cacheBlockedUserIds',

        self::STAMP_REGISTRATION      => 'stampRegistration',
        self::STAMP_LAST_UPDATE       => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return UserModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    public static function privateAttributes(): array
    {
        return array(
            self::EMAIL              => self::CAMEL_CASE_MAP[self::EMAIL],
            self::META_ACCESS        => self::CAMEL_CASE_MAP[self::META_ACCESS],
            self::META_PUSH_SETTINGS => self::CAMEL_CASE_MAP[self::META_PUSH_SETTINGS],
            self::STAMP_REGISTRATION => self::CAMEL_CASE_MAP[self::STAMP_REGISTRATION],
        );
    }

    public static function protectedAttributes(): array
    {
        return array(
            self::PASSWORD               => self::CAMEL_CASE_MAP[self::PASSWORD],
            self::META_IS_EMAIL_VERIFIED => self::CAMEL_CASE_MAP[self::META_IS_EMAIL_VERIFIED],
            self::STAMP_LAST_UPDATE      => self::CAMEL_CASE_MAP[self::STAMP_LAST_UPDATE],
            self::CACHE_BLOCKED_USER_IDS => self::CAMEL_CASE_MAP[self::CACHE_BLOCKED_USER_IDS],
        );
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function validators(): array
    {
        return array(
            self::EMAIL              => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::EMAIL]),
            self::USERNAME           => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::USERNAME]),
            self::PASSWORD           => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::PASSWORD]),

            self::DISPLAY_NAME       => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_NAME]),
            self::DISPLAY_BIO        => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_BIO]),
            self::DISPLAY_WEB        => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_WEB]),

            self::META_IS_PRIVATE    => array(UserValidator::erlClass(), self::CAMEL_CASE_MAP[self::META_IS_PRIVATE]),
            self::META_PUSH_SETTINGS => UserMetaPushSettingsDTO::validator(),
        );
    }

    public static function transformers(): array
    {
        return array(
            self::PASSWORD    => array(UserTransformer::erlClass(), self::CAMEL_CASE_MAP[self::PASSWORD]),

            self::META_ACCESS => array(UserTransformer::erlClass(), self::CAMEL_CASE_MAP[self::META_ACCESS]),
        );
    }

    public static function serializers(): array
    {
        return array(
            self::DISPLAY_IMAGE          => UserDisplayImageDTO::serializer(),

            self::META_PUSH_SETTINGS     => UserMetaPushSettingsDTO::serializer(),

            self::CACHE_BLOCKED_USER_IDS => UserIdsDTO::serializer(),
        );
    }

    public static function deSerializers(): array
    {
        return array(
            self::DISPLAY_IMAGE          => UserDisplayImageDTO::deSerializer(),

            self::META_PUSH_SETTINGS     => UserMetaPushSettingsDTO::deSerializer(),

            self::CACHE_BLOCKED_USER_IDS => UserIdsDTO::deSerializer(),
        );
    }
}
